---
generated_at: 2026-02-03 11:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-Spark Connect Server Overview（Connect Server概要）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerPage.scala` 行34-527
- E-02: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerTab.scala` 行27-59
- E-03: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/SparkConnectServerAppStatusStore.scala` 行29-131
- E-04: `sql/connect/server/src/main/scala/org/apache/spark/sql/connect/ui/ToolTips.scala` 行20-39
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv` No.20
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv` No.20
- E-07: `docs/code-to-docs/画面遷移図.md` ConnectTab

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLパスは/connect/ | E-02 行30: SparkUITab(sparkUI, "connect") | ○ |
| C-02 | デフォルトページ | E-01 行35: WebUIPage("") | ○ |
| C-03 | store.synchronizedでrender実行 | E-01 行43: store.synchronized | ○ |
| C-04 | 基本情報にStarted at/Time since start表示 | E-01 行60-70: generateBasicStats | ○ |
| C-05 | オンラインセッション数表示 | E-01 行47: store.getOnlineSessionNum; E-03 行38-40: finishTimestamp == 0で判定 | ○ |
| C-06 | 実行中リクエスト数表示 | E-01 行50: store.getTotalRunning; E-03 行63-64: isExecutionActive | ○ |
| C-07 | Session Statistics テーブル6列構成 | E-01 行386-392: User/Session ID/Start Time/Finish Time/Duration/Total Execute | ○ |
| C-08 | Request Statistics テーブル15列構成（showSessionLink=true） | E-01 行215-230: 15列ヘッダ定義 | ○ |
| C-09 | Session IDリンクがセッション詳細へ遷移 | E-01 行407-410, 413: sessionLink = /connect/session/?id={sessionId} | ○ |
| C-10 | Job IDリンクがジョブ詳細へ遷移 | E-01 行336-337: jobURL = /jobs/job/?id={jobId} | ○ |
| C-11 | SQL Query IDリンクがSQL実行詳細へ遷移 | E-01 行339-340: sqlURL = /SQL/execution/?id={sqlExecId} | ○ |
| C-12 | セクション折りたたみ機能（Session Statistics） | E-01 行154-155: collapseTable | ○ |
| C-13 | セクション折りたたみ機能（Request Statistics） | E-01 行108-109: collapseTable | ○ |
| C-14 | テーブルレンダリングエラーハンドリング | E-01 行94-101, 140-147: IllegalArgumentException/IndexOutOfBoundsExceptionキャッチ | ○ |
| C-15 | データ0件時の「No statistics have been generated yet.」表示 | E-01 行116, 163: table.getOrElse("No statistics have been generated yet.") | ○ |
| C-16 | ページタイトルは「Spark Connect」 | E-01 行56: headerSparkPage(request, "Spark Connect", content, parent) | ○ |
| C-17 | タブ名は「Connect」 | E-02 行33: override val name = "Connect" | ○ |
| C-18 | displayOrder = 3 | E-02 行50: override def displayOrder: Int = 3 | ○ |
| C-19 | isExecutionActiveの判定条件 | E-03 行113-117: STARTED/COMPILED/READY | ○ |
| C-20 | State列のRUNNING表示 | E-01 行321: if (info.isExecutionActive) "RUNNING" else info.state | ○ |
| C-21 | ToolTipのFinish Time/Close Time/Execution/Duration定義 | E-04 行21-37: 4つのツールチップ文字列 | ○ |
| C-22 | startTime取得のフォールバック | E-02 行36-41: NoSuchElementExceptionキャッチで現在時刻にフォールバック | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 画面仕様がソースコードと完全に一致

## 6) レビュアーチェックリスト（最小）
- [ ] セッション大量登録時のページングパフォーマンスが問題ないか確認
- [ ] isExecutionActive状態のリクエストが「RUNNING」と表示される仕様が業務要件と合致するか確認
- [ ] Spark Connect Server未使用環境でConnectタブが非表示になることの確認
